#! /bin/bash

FILES=/opt/apps/com.gdca.gdcaclient/files
BINPAYH=/opt/apps/com.gdca.gdcaclient/files/bin
LIBPATH=/opt/apps/com.gdca.gdcaclient/files/lib

#添加环境变量
ARCH=`arch`
if [ "$ARCH" = "mips64" ];then
    ARCH_LINUX_GNU=mips64el-linux-gnuabi64
else
    ARCH_LINUX_GNU=${ARCH}"-linux-gnu"
fi

#export PATH="$BINPAYH:$PATH"
export LD_LIBRARY_PATH="$LIBPATH:$LIBPATH/$ARCH_LINUX_GNU:$LD_LIBRARY_PATH"
echo $LD_LIBRARY_PATH

cd /opt/apps/com.gdca.gdcaclient/files/bin/

#360浏览和奇安信浏览器安装证书
for i in /home/*;do
    User=${i##*/}
    echo "User=$User"
    mkdir -p $i/.pki/nssdb/.config/qaxbrowser
    
    CERTPATH=$i/.pki/nssdb
    echo "install 360 certificate:$CERTPATH"  
    ./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d dbm:$CERTPATH
    ./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d dbm:$CERTPATH
    ./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d sql:$CERTPATH
    ./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d sql:$CERTPATH      
    ./certutil -d sql:$CERTPATH -L

    CERTPATH=$i/.pki/nssdb/.config/qaxbrowser
    echo "install qaxbrowser certificate: $CERTPATH"   
    ./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d dbm:$CERTPATH
    ./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d dbm:$CERTPATH
    ./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d sql:$CERTPATH
    ./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d sql:$CERTPATH    
    ./certutil -d sql:$CERTPATH -L

    chown -R $User:$User $i/.pki


    firefoxpath=$i/.mozilla/firefox
    if [ -f $firefoxpath/profiles.ini ];then
        	FILENUM=`cat $firefoxpath/profiles.ini | grep "^Path=" | awk -F= '{print $2}' | wc -l` 
        	for ((j=1;j<=$FILENUM;j++));
        	do
		    FILENAME=`cat $firefoxpath/profiles.ini | grep "^Path=" | awk -F= '{print $2}' | head -n $j | tail -n 1`
       	    FILEPATH=$i/.mozilla/firefox/$FILENAME       		           
       		if [ -d $FILEPATH  ];then
			echo "install firefox certificate: $FILEPATH"
			./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d dbm:$FILEPATH
			./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d dbm:$FILEPATH
			./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d sql:$FILEPATH
			./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d sql:$FILEPATH
			./certutil -d sql:$FILEPATH -L
		fi
        	done     
    fi
    
    firefoxpath=$i/.mozilla/firefox-esr
    if [ -f $firefoxpath/profiles.ini ];then
        	FILENUM=`cat $firefoxpath/profiles.ini | grep "^Path=" | awk -F= '{print $2}' | wc -l` 
        	for ((j=1;j<=$FILENUM;j++));
        	do
		    FILENAME=`cat $firefoxpath/profiles.ini | grep "^Path=" | awk -F= '{print $2}' | head -n $j | tail -n 1`
       	    FILEPATH=$i/.mozilla/firefox-esr/$FILENAME       		           
       		if [ -d $FILEPATH  ];then
			echo "install firefox certificate: $FILEPATH: "
			./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d dbm:$FILEPATH
			./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d dbm:$FILEPATH
			./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d sql:$FILEPATH
			./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d sql:$FILEPATH
			./certutil -d sql:$FILEPATH -L
		fi
        	done     
    fi
    
    if [ -d $i/.mozilla ];then
        chown -R $User:$User $i/.mozilla
    fi

done
unset i



 
