#! /bin/bash

FILES=/opt/apps/com.gdca.gdcaclient/files
BINPAYH=/opt/apps/com.gdca.gdcaclient/files/bin
LIBPATH=/opt/apps/com.gdca.gdcaclient/files/lib

#添加环境变量
ARCH=`arch`
if [ "$ARCH" = "mips64" ];then
    ARCH_LINUX_GNU=mips64el-linux-gnuabi64
else
    ARCH_LINUX_GNU=${ARCH}"-linux-gnu"
fi

#export PATH="$BINPAYH:$PATH"
export LD_LIBRARY_PATH="$LIBPATH:$LIBPATH/$ARCH_LINUX_GNU:$LD_LIBRARY_PATH"
echo $LD_LIBRARY_PATH

cd /opt/apps/com.gdca.gdcaclient/files/bin/
#火狐导入证书
for j in /home/*/.mozilla; do

	for k in $j/firefox*; do

	if [ -f $k/profiles.ini ];then

    	FILENUM=`cat $k/profiles.ini | grep "^Path=" | awk -F= '{print $2}' | wc -l`  	

    	for ((i=1;i<=$FILENUM;i++));
    	do
		FILENAME=`cat $k/profiles.ini | grep "^Path=" | awk -F= '{print $2}' | head -n $i | tail -n 1`
       		FILEPATH=$k/$FILENAME       		           
       		if [ -d $FILEPATH  ];then
			#CertUtil=`./certutil -d sql:$FILEPATH -L | grep "Certificate Client Service"`
			echo "install firefox certificate: $FILEPATH: "
			./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d dbm:$FILEPATH
			./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d dbm:$FILEPATH
			./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d sql:$FILEPATH
			./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d sql:$FILEPATH
			./certutil -d sql:$FILEPATH -L
		fi

    	done
    	unset i
	fi

	done
	unset k

done
unset j


#360浏览和系统浏览器安装证书
for i in /home/*/.pki/nssdb/;do
    if [ -d $i ];then 
        #CertUtil=`./certutil -d sql:$i -L | grep "Certificate Client Service"`  
        echo "install 360 certificate: $i"  
        ./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d dbm:$i
        ./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d dbm:$i
        ./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d sql:$i
        ./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d sql:$i         
        ./certutil -d sql:$i -L
    fi
done
unset i

#奇安信浏览器安装证书
for i in /home/*/.pki/nssdb/.config/qaxbrowser/;do  
    if [ -d $i ];then  
        #CertUtil=`./certutil -d sql:$i -L | grep "Certificate Client Service"`
        echo "install qaxbrowser certificate: $i"   
        ./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d dbm:$i
        ./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d dbm:$i
        ./certutil -A -n "Certificate Client Service Root 0" -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_Root_0.crt -d sql:$i
        ./certutil -A -n "Certificate Client Service CA 0"   -t "C,C,C" -i $FILES/certs/Certificate_Client_Service_CA_0.crt   -d sql:$i       
        ./certutil -d sql:$i -L
    fi
done
unset i
