#! /bin/bash

# PC/SC服务卸载脚本
# pcscd, pcsc-lite, drivers, pkcs11, user tool
# WatchData

# pcsc daemon名称
DAEMON_NAME=wdpcscd_gdca

# 通讯服务名称
WDSERVER_NAME=WDTokenServer_gdca

# UI进程名称
UI_NAME=WDUIServer_gdca

#终止UI进程
KillUI () {

	UIlist=$(ps -ef | grep "$UI_NAME" | grep -v grep | awk '{print $2}')
	if [ -n "$UIlist" ];then
		echo "	UIServer is running, will stop it ..."
		echo $UIlist | while read pid; do
			kill -9 $pid
		done
	fi
}

#终止已运行的服务
KillService () {
	
	#终止服务进程
	pidlist=$(ps -ef | grep "$DAEMON_NAME" | grep -v grep | awk '{print $2}')
	if [ -n "$pidlist" ];then
		echo $pidlist | while read pid; do
			kill -9 $pid
		done
		sleep 02s
	fi

	#检查结果
	pidlist=$(ps -ef | grep "$DAEMON_NAME" | grep -v grep | awk '{print $2}')
	if [ -n "$pidlist" ];then
		echo "	can't stop $DAEMON_NAME."
		ErrFail
	else
		echo "	$DAEMON_NAME has been stoped."
	fi

	#清理
	if [ -e /tmp/$DAEMON_NAME.comm ]; then
		rm -f /tmp/$DAEMON_NAME.comm
	fi
	if [ -e /tmp/$DAEMON_NAME.pid ]; then
		rm -f /tmp/$DAEMON_NAME.pid
	fi

	serverlist=$(ps -ef | grep "$WDSERVER_NAME" | grep -v grep | awk '{print $2}')
	if [ -n "$serverlist" ];then
		echo "	WDTokenServer is running, will stop it ..."
		echo $serverlist | while read pid; do
			kill -9 $pid
		done
	fi
}

#终止UI进程
KillUI

#终止已运行的服务
KillService

exit 0

