#!/bin/bash

# PCSCװű
# pcscd, pcsc-lite, drivers, pkcs11, user tool
# GDCA

# pcsc daemon
DAEMON_NAME=gdca_pcscd

# Ŀ¼λ
DIR_FILES=/opt/apps/com.gdca.gdcaclient/files

# ϵͳֳ 32/64
SYSLONGBIT=

# űλ
SERVICE_INIT_SCRIPT_DIR=

# װеĽű
SCR_NAME=

# װλ
PackPath=

# аϢ
ReleaseInfo=

# ܹϢ
MachineInfo=

# 
BIN_update_rc_d="/usr/sbin/update-rc.d"
BIN_chkconfig="/sbin/chkconfig"
BIN_insserv="/sbin/insserv"

# getconfλ
BIN_getconf='/usr/bin/getconf'

ErrFail() {
	echo ''
	echo '	install failed.'
	echo ''
	exit -1
}

#ȡϵͳϢ
GetSystemInfo () {

	MachineInfo=$(uname -m)
	echo "	Machine architecture is $MachineInfo ..."

	if [ -e /etc/os-release ]; then
		ReleaseInfo=$(cat /etc/os-release)
	elif [ -e /etc/issue ]; then
		ReleaseInfo=$(cat /etc/issue)
	fi
	
	case "$ReleaseInfo" in
	*'NeoKylin'*)
		echo '	Linux Release is NeoKylin ...'
		ReleaseInfo='Fedora'
		;;
	*'Kylin'*)
		echo '	Linux Release is kylin ...'
		ReleaseInfo='Ubuntu'
		;;
	*'uos'*)
		echo '	Linux Release is UOS ...'
		ReleaseInfo='Ubuntu'
		;;
	*'openSUSE'*)
		echo '	Linux Release is openSUSE ...'
		ReleaseInfo='openSUSE'
		;;
	*'Ubuntu'*)
		echo '	Linux Release is Ubuntu ...'
		ReleaseInfo='Ubuntu'
		;;
	*'Fedora'*)
		echo '	Linux Release is Fedora ...'
		ReleaseInfo='Fedora'
		;;
	*'Debian'*)
		echo '	Linux Release is Debian ...'
		ReleaseInfo='Debian'
		;;
	*'Red Hat'*)
		echo '	Linux Release is Red Hat ...'
		ReleaseInfo='Fedora'
		;;
	*'CentOS'*)
		echo '	Linux Release is CentOS ...'
		ReleaseInfo='Fedora'
		;;		
	*)
		echo "	!!! Can't get your Linux release info, WatchSAFE maybe don't work. !!!"
		echo "	"
	esac

	SYSLONGBIT=$($BIN_getconf LONG_BIT)
	echo "	System LONGBIT is $SYSLONGBIT ..."
	if [ ${SYSLONGBIT} -gt 32 ]; then
		SYSLONGBIT='64bit'
	else
		SYSLONGBIT='32bit'
	fi
}


#ֹеķ
KillService () {

	#ֹ
	pidlist=$(ps -ef | grep "$DAEMON_NAME" | grep -v grep | awk '{print $2}')
	if [ -n "$pidlist" ];then
		echo "	$DAEMON_NAME is runing, will stop it ..."
		service $DAEMON_NAME stop
		sleep 01s

		#ûзĻֱֹ
		pidlist=$(ps -ef | grep "$DAEMON_NAME" | grep -v grep | awk '{print $2}')
		if [ -n "$pidlist" ];then
			echo $pidlist | while read pid; do
				kill -9 $pid
			done
			sleep 03s
		fi

		#
		pidlist=$(ps -ef | grep "$DAEMON_NAME" | grep -v grep | awk '{print $2}')
		if [ -n "$pidlist" ];then
			echo "	can't stop $DAEMON_NAME."
			ErrFail
		else
			echo "	$DAEMON_NAME has been stoped."
		fi

	else
		echo "	there are no $DAEMON_NAME runing."
	fi

	#
	if [ -e /var/run/$DAEMON_NAME/$DAEMON_NAME.comm ]; then
		rm -f /var/run/$DAEMON_NAME/$DAEMON_NAME.comm
	fi
	if [ -e /var/run/$DAEMON_NAME/$DAEMON_NAME.pid ]; then
		rm -f /var/run/$DAEMON_NAME/$DAEMON_NAME.pid
	fi

}

#жط
RemoveSrv() {
	if [ -e $BIN_update_rc_d ]; then
		echo "	using update-rc.d ..."
		$BIN_update_rc_d -f $DAEMON_NAME remove

	elif [ -e $BIN_chkconfig ]; then
		echo "	using chkconfig ..."
		$BIN_chkconfig --del $DAEMON_NAME

	elif [ -e $BIN_insserv ]; then
		echo "	using insserv ..."
		$BIN_insserv -r $DAEMON_NAME

	else
		echo "	there no tools to remove service ..."
		ErrFail
	fi

	if [ -e /etc/init.d/$DAEMON_NAME ]; then
		rm -f /etc/init.d/$DAEMON_NAME
	fi

	if [ -e /etc/rc.d/init.d/$DAEMON_NAME ]; then
		rm -f /etc/rc.d/init.d/$DAEMON_NAME
	fi
}


# Begin Now !

echo ''
echo "	begin to install $DAEMON_NAME ..."
echo ''

#ȡű·
PackPath=$(dirname $0)

#ȡϵͳϢ
GetSystemInfo

#ֹ
echo "	find and kill $DAEMON_NAME in system ..."
KillService

#жط
if [ -e /etc/init.d/$DAEMON_NAME ]; then
	echo "	remove gdca_pcscd service ..."
	RemoveSrv
elif [ -e /etc/rc.d/init.d/$DAEMON_NAME ]; then
	echo "	remove gdca_pcscd service ..."
	RemoveSrv
fi

sleep 02s

echo ''
echo '	uninstall completed.'
echo ''

exit 0
