var gsSelectUser = '';
var gsSelectContainer = '';
var gUserList = [];
var gIsLogin = false;
var gIsScan = false;
var t1;
var t2;
var g_api_ver = '';
var g_timer_get_ver = '';

function clearForm() {
    testForm.dev_info.value = "";
    testForm.sign_cert.value = "";
    testForm.enc_cert.value = "";
    testForm.CertInfo.value = "";
    testForm.CertInfo2.value = "";
    testForm.SignMsgInfo.value = "";
    testForm.SignedData.value = "";
    testForm.signed_msg.value = "";
    testForm.EncryptedData.value = "";
    testForm.DecryptedData.value = "";
    testForm.RandomData.value = "";
}

function OnEncryptPlainDataChannged(obj) {
	$('#enc_pdata_len').html(String(obj.value.length));
}

function UpdateProtocol() {
	var proto = parseInt(get_radio_val("http_protocol"));
	gPKISvc.setProtocol(proto);

	g_login = false;
}

function parse_trustid(trustid) {
	if(trustid.substr(0, 2) == '..') return trustid.substr(2);
	return trustid;
}

function ClearListBox(obj_id) {
	$('#'+obj_id).html('');
}

window.onload=function(){
	testForm.api_version.value = "";

	clearForm();

	UpdateProtocol();

	$("input[name=http_protocol]").click(function(){
	    UpdateProtocol();
	});
	
	//实际应用中可用下面的代码判断url的协议来设置通讯方式
	//var isHttps = location.href.indexOf("https");
	//if (isHttps == -1) 
	//	gPKISvc.setProtocol(PROTO_HTTP);
	//else
	//	gPKISvc.setProtocol(PROTO_HTTPS);
	
	Test_GetVersion();

	g_timer_get_ver = window.setInterval(timerCheckGetVer, 500);
};

function timerCheckGetVer() {
	if(g_api_ver != ''){
		clearInterval(g_timer_get_ver);
		if(!xs_compare_ver(g_api_ver, "1.1.3")){
			alert('您的证书客户端版本太低，需要4.2.1及以上版本！');
		}
	}
}

window.onbeforeunload = function(){
}  

window.onunload = function(){  
}  


function ShowError(e)
{
    if(e.ErrorMsg != undefined){
        alert("\n错误信息：" + e.ErrorMsg + "\n错误代码：0x" + e.ErrorCode.toString(16).toUpperCase() + " (" + gPKISvc.Errcode2Msg(e.ErrorCode) + ")");
    }
    else
        alert("Exception:\n" + e.ErrorMsg);
}

function ReSetData()
{
    gsSelectUser = "";
    gsSelectContainer = "";
}

function OnCertTypeChange()
{
    testForm.CertData.value = "";
}

function OnUserSelected()
{
    ReSetData();
    clearForm();

    var Index = testForm.UserList.options.selectedIndex;

    var sUser = gUserList[Index];

    var UserInfo = sUser.split("||");
    
    gsSelectUser = UserInfo[0];
    gsSelectContainer = UserInfo[1];

	gIsScan = gsSelectContainer == 'SCAN_CONTAINER';
}

function OnEncFileChanged() {
    var sPath = document.getElementById('EncInFilePath').value;
    document.getElementById('EncOutFilePath').value = FilePathAddSufix(sPath, "_encrypted");
}

function OnDecFileChanged() {
    var sPath = document.getElementById('DecInFilePath').value;
    document.getElementById('DecOutFilePath').value = FilePathAddSufix(sPath, "_decrypted");
}

function OnExtEncFileChanged() {
    var sPath = document.getElementById('ExtEncInFilePath').value;
    document.getElementById('ExtEncOutFilePath').value = FilePathAddSufix(sPath, "_encrypted");
}

function OnExtDecFileChanged() {
    var sPath = document.getElementById('ExtDecInFilePath').value;
    document.getElementById('ExtDecOutFilePath').value = FilePathAddSufix(sPath, "_decrypted");
}

function CheckCert(cert_type)
{
    if(cert_type == CERT_TYPE_SIGN && testForm.sign_cert.value == '')
    {
        alert("签名证书为空！");
        return false;
    }
    else if(cert_type == CERT_TYPE_EXCHANGE && testForm.enc_cert.value == '')
    {
        alert("加密证书为空！");
        return false;
    }

    return true;
}

function CheckUser()
{
    if(gsSelectContainer == '')
    {
        alert("请先枚举证书！");
        return false;
    }

    return true;
}

function CheckLogin()
{
	if(gIsScan) return true;
	
    if(!gIsLogin)
    {
        alert("请先登录！");
        return false;
    }

    return true;
}

function CheckScan()
{
    if(gIsScan){
	    alert("本功能不支持一扫签！");
	    return false;
    }

    return true;
}

function UpdateSetSupportDevFlags()
{
	var dev_csp = document.getElementById('dev_csp');
	var dev_online = document.getElementById('dev_online');
	var setVal = 0;

	if(dev_csp.checked)
		setVal |= DEV_GDCA_CSP;
		
	if(dev_online.checked)
		setVal |= DEV_ONLINE;
		
	testForm.dev_flags.value = setVal;
}

function SupportDeviceClick()
{
	UpdateSetSupportDevFlags();
}

//1.获取接口版本号
function Test_GetVersion()
{
	testForm.api_version.value = '';
	
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_GetVersion(function(res){
		t2 = new Date().getTime();
		testForm.elapse1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.api_version.value = res.Result.Version;
			g_api_ver = res.Result.Version;
		}else
			ShowError(res);
    });
}

//2.获取产品版本号
function Test_GetProductVersion()
{
	var product_type = parseInt(testForm.product_type.value);	
	testForm.product_version.value = '';

	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_Ext_GetProductVersion(product_type, function(res){
		t2 = new Date().getTime();
		testForm.elapse2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.product_version.value = res.Result.Version;
		}else
			ShowError(res);
    });
}

//3.设置多CA兼容设备
function Test_ConfigSupportDevice()
{
	var dev_flags = parseInt(testForm.dev_flags.value);

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Config(SOF_SET_SUPPORT_DEVICE_EX, dev_flags, function(res){
		t2 = new Date().getTime();
		testForm.elapse7.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("设置成功");
		}else
			ShowError(res);
    });
}

function Test_Config()
{
	var set_type = parseInt(document.getElementById('set_type').value);
	var set_val = document.getElementById('set_val').value;
	var set_data_type = parseInt(document.getElementById('set_data_type').value);

	if(set_data_type == 1)
		set_val = parseInt(set_val);

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Config(set_type, set_val, function(res){
		t2 = new Date().getTime();
		testForm.elapse4.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("设置成功");
		}else
			ShowError(res);
    });
}

//4.设置数据输入格式
function SetInDataFormat()
{
	var indata_format = parseInt(document.getElementById('indata_format').value);

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Config(SOF_SET_INDATA_FORMAT, indata_format, function(res){
		t2 = new Date().getTime();
		testForm.elapse4.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("设置成功");
		}else
			ShowError(res);
    });
}

//设置服务响应超时
function Test_ConfigServerTimeout()
{
	var set_times = parseInt(document.getElementById('server_timeout').value);

	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_Config(SOF_SET_HTTP_TIMEOUT, set_times, function(res){
		t2 = new Date().getTime();
		testForm.elapse4.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("设置成功");
		}else
			ShowError(res);
    });
}

//5.枚举设备
function Test_EnumDevice()
{
	testForm.enum_dev.value = '';

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_EnumDevice(function(res){
		t2 = new Date().getTime();
		testForm.elapse5.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.enum_dev.value =res.Result.DeviceInfo;
			var devTypeList = JSON.parse(res.Result.DeviceInfo);
			if(devTypeList.length == 0){
				alert("没有检测到UKey！");
			}
		}else
			ShowError(res);
    });
}

//6.获取设备类型
function Test_GetDeviceType()
{
	testForm.dev_type.value = '';
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_GetDeviceType(function(res){
		t2 = new Date().getTime();
		testForm.elapse6.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.dev_type.value =res.Result.devType;
		}else
			ShowError(res);
    });
}

//7.枚举用户
function Test_EnumUser(obj)
{
	document.getElementById("UserList").options.length = 0; 

	obj.disabled = true;

	t1 = new Date().getTime();
	
	gPKISvc.SOF_GetUserList(function(res){
		t2 = new Date().getTime();

		if(res.ErrorCode == SOR_OK && res.Status == 1){
			
			gUserList =	res.Result;
			for (i = 0; i < res.Result.length; i++)
	            testForm.UserList.options.add(new Option(res.Result[i]), i);
		
			testForm.UserList.options[0].selected=true;		
			OnUserSelected();	
		}else{
			if(res.ErrorCode == SOR_OK && res.Status == 0)
				alert("找不到证书！");
			else
				ShowError(res);
		}
		
		obj.disabled = false;
		testForm.elapse7.value = t2 - t1;
	});
}

//8.获取设备信息
function Test_GetDeviceInfo()
{
	document.getElementById('dev_info').value = '';	
	
	var devInfoType = parseInt(testForm.DevInfoType.value, 16);
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_GetDeviceInfo(gsSelectContainer, devInfoType, function(res){
		t2 = new Date().getTime();
		testForm.elapse8.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.dev_info.value =res.Result.DeviceInfo;
		}else{
			testForm.dev_info.value = "";
			if(res.ErrorCode == SOR_NotSupportYetErr)
				alert("设备不支持此属性！");
			else
				ShowError(res);
		}
    });
}

//9.用户登录
function Test_Login()
{
    if(!CheckScan()) return;
       
    if(!CheckUser())
       return;
       
    var sPassword = testForm.password.value;
    if(sPassword == "")
    {
        alert("请输入密码!");
        return;
    }
        
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_Login(gsSelectContainer, sPassword, function(res){
		t2 = new Date().getTime();
		testForm.elapse9.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("登录成功");
			gIsLogin = true;
		}else
			ShowError(res);
    });
}

//10.判断是否登陆
function Test_IsLogin()
{
	if(!CheckScan()) return;
       
    if(!CheckUser())
       return;
       
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_Ext_isLogin(gsSelectContainer, 1, function(res){
		t2 = new Date().getTime();
		testForm.elapse10.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("已登录");
		}else if(res.ErrorCode == SOR_NotLoginErr)
			alert("未登录");
		else
			ShowError(res);
    });
}

//11.获取口令剩余重试次数
//多CA兼容时获取剩余重试次数
function Test_GetPinRetryCount()
{
	testForm.PinRetryCount.value = '';
	
	if(!CheckScan()) return;
	
    if(!CheckUser())
        return;

	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_GetPinRetryCount(gsSelectContainer, function(res){
		t2 = new Date().getTime();
		testForm.elapse11.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.PinRetryCount.value =res.Result.RetryCount;
		}else
			ShowError(res);
    });
}

//12.退出登录
function Test_Ext_Logout()
{
	if(!CheckScan()) return;
       
    if(!CheckUser())
       return;
       
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_Ext_Logout(gsSelectContainer, 1, function(res){
		t2 = new Date().getTime();
		testForm.elapse12.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("登出成功");
			gIsLogin = false;
		}else
			ShowError(res);
    });
}

//13.修改密码
function Test_ChangePassWd()
{
	if(!CheckScan()) return;
	
    if(!CheckUser())
        return;
        
    var oldpin = testForm.OldPassword.value;
    var newpin = testForm.NewPassword.value;
    if(oldpin == "" || newpin == "")
    {
        alert("请输入完整!");
        return;
    }
        
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_ChangePassWd(gsSelectContainer, oldpin, newpin, function(res){
		t2 = new Date().getTime();
		testForm.elapse13.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("修改密码成功");
		}else
			ShowError(res);
    });
}

//14.读取证书
function Test_ReadUserCert(certType)
{
    if(!CheckUser())
        return;
        
    var cert_type = parseInt(certType);
	var sContainer = gsSelectContainer;
	
	t1 = new Date().getTime();

	if(cert_type == 1){
		testForm.sign_cert.value = '';
		
	    var res = gPKISvc.SOF_ExportUserCert(sContainer, function(res){
			t2 = new Date().getTime();
			testForm.elapse14_1.value = t2 - t1;
			
			if(res.ErrorCode == SOR_OK){
				testForm.sign_cert.value = res.Result.UserCert;
			}else
				ShowError(res);
	    });
	}
	else{
		testForm.enc_cert.value = '';
		
	    var res = gPKISvc.SOF_ExportExChangeUserCert(sContainer, function(res){
			t2 = new Date().getTime();
			testForm.elapse14_2.value = t2 - t1;
			
			if(res.ErrorCode == SOR_OK){
				testForm.enc_cert.value = res.Result.UserCert;
			}else
				ShowError(res);
	    });
	}
}

//15.解析证书信息
function Test_GetCertInfo(obj)
{
    var info_type = parseInt(testForm.CertInfoType.value, 16);
	var cert_type = parseInt(testForm.CertType1.value);
	var usercert = '';

	$('textarea[id="CertInfo"]').val('');
	
    if(!CheckCert(cert_type))
        return;

	obj.disabled = true;

	usercert = (cert_type == CERT_TYPE_SIGN)?testForm.sign_cert.value:testForm.enc_cert.value;

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_GetCertInfo(usercert, info_type, function(res){
		t2 = new Date().getTime();
		testForm.elapse15.value = t2 - t1;
		obj.disabled = false;
		
		if(res.ErrorCode == SOR_OK){
			if(info_type == SGD_CERT_ISSUER 
			|| info_type == SGD_CERT_SUBJECT
			|| info_type == SGD_CERT_ISSUER_CN
			|| info_type == SGD_CERT_ISSUER_O
			|| info_type == SGD_CERT_ISSUER_OU
			|| info_type == SGD_CERT_SUBJECT_O
			|| info_type == SGD_CERT_SUBJECT_OU
			|| info_type == SGD_CERT_SUBJECT_CN
			|| info_type == SGD_CERT_SUBJECT_EMAIL
			|| info_type == SGD_CERT_DER_PUBLIC_KEY
			|| info_type == SGD_CERT_DER_EXTENSIONS){
				$('#CertInfo').val(res.Result.Info);
			}else{
				$('#CertInfo').val(gPKISvc.base64Decode(res.Result.Info));
			}
		}else{
			$('#CertInfo').val("");
			ShowError(res);
		}
    });
}

//16.解析证书信息（OID）
function Test_GetCertInfoByOid()
{
    var oid_name = testForm.OIDNameSel.value;
	var cert_type = parseInt(testForm.CertType2.value);
	var usercert = '';

	testForm.CertInfo2.value = '';
	
    if(!CheckCert(cert_type))
        return;

	usercert = (cert_type == CERT_TYPE_SIGN)?testForm.sign_cert.value:testForm.enc_cert.value;

    if(oid_name == "0"){
        if(testForm.OID.value == '')
        {
            alert("请填写OID");
            return;
        }
        oid_name = testForm.OID.value;
    }

	t1 = new Date().getTime();	

    var res = gPKISvc.SOF_GetCertInfoByOid(usercert, oid_name, function(res){
		t2 = new Date().getTime();
		testForm.elapse16.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			var info = gPKISvc.base64Decode(res.Result.Info);
			
			if(oid_name == '1.2.86.21.1.3')
				res = parse_trustid(info);
			testForm.CertInfo2.value = info;
		}else{
			testForm.CertInfo2.value = "";
			ShowError(res);
		}
    });
}

//17.证书验证
function Test_ValidateCert()
{
	var cert_type = parseInt(testForm.CertType3.value);
	var usercert = '';

    if(!CheckCert(cert_type))
        return;
        
	usercert = (cert_type == CERT_TYPE_SIGN)?testForm.sign_cert.value:testForm.enc_cert.value;
	
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_ValidateCert(usercert, function(res){
		t2 = new Date().getTime();
		testForm.elapse17.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("证书验证通过");
		}else{
			switch (res.ErrorCode) 
			{
			case SOF_CERT_NOT_TRUSTED:
				alert("证书验证失败：证书不被信任！");
				break;
				
			case SOF_CERT_HASEXPIRED:
				alert("证书验证失败：证书已过有效期！");
				break;
				
			case SOF_CERT_REVOKED:
				alert("证书验证失败：证书已被吊销！");
				break;
				
			case SOF_CERT_FROZEN:
				alert("证书验证失败：证书已被冻结！");
				break;
				
			case SOF_CERT_NOTYETVALID:
				alert("证书验证失败：证书未生效！");
				break;
				
			case SOF_CERT_OTHER_ERR:
				alert("证书验证失败！");
				break;
				
			default:
				alert("证书验证失败(0x" + res.ErrorCode.toString(16).toUpperCase() + ")！");
				break;
			}
		}
    });
}

//18.P1签名验签
function Test_Sign()
{
	testForm.SignedData.value = '';
	
    if(!CheckUser())
        return;

	var sSignPlainData = testForm.SignPlainData.value;
	
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_SignData(gsSelectContainer, sSignPlainData, function(res){
		t2 = new Date().getTime();
		testForm.elapse18_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.SignedData.value = res.Result.Sign;
			alert("P1签名成功!");
		}else{
			//此处错误码判断，需要4.1.7以上版本
			if(res.ErrorCode == SOR_RsaEncErr || res.ErrorCode == SOR_ECCEncErr)
				alert("P1签名失败，请确认是否登录!");
			else if(res.ErrorCode == SOF_CERT_HASEXPIRED)
				alert("P1签名失败，证书已过期!");
			else if(res.ErrorCode == SOF_CERT_REVOKED)
				alert("P1签名失败，证书已被吊销!");
			else if(res.ErrorCode == SOF_CERT_NOT_TRUSTED)
				alert("P1签名失败，证书不被信任!");
			else if(res.ErrorCode == SOR_IndataErr)
				alert("P1签名失败：原文不是Base64格式!");
			else
				ShowError(res);
		}
    });
}

//18.P1签名验签
function Test_Verify()
{
    var sign_cert = testForm.sign_cert.value;
    var plain_data = testForm.SignPlainData.value;
    var signed_data = testForm.SignedData.value;
    
	if(sign_cert.length == 0 || sign_cert == null){
		alert("签名证书为空");
		return;
	}
	
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_VerifySignedData(sign_cert, plain_data, signed_data, function(res){
		t2 = new Date().getTime();
		testForm.elapse18_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("P1验签成功");
		}else
			ShowError(res);
    });
}

//20.P1文件验签
function Test_PKCS1_File_Sign()
{
	testForm.FileSignedValue.value = '';
    if(!CheckUser())
       return;

	var sInFilePath = testForm.SignInFilePath.value;

	t1 = new Date().getTime();


    var res = gPKISvc.SOF_SignFile(gsSelectContainer, sInFilePath, function(res){
		t2 = new Date().getTime();
		testForm.elapse20_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.FileSignedValue.value = res.Result.Sign;
			alert("P1文件签名成功");
		}else{
			//此处错误码判断，需要4.1.7以上版本
			if(res.ErrorCode == SOR_RsaEncErr || res.ErrorCode == SOR_ECCEncErr)
				alert("P1文件签名失败，请确认是否登录!");
			else if(res.ErrorCode == SOF_CERT_HASEXPIRED)
				alert("P1文件签名失败，证书已过期!");
			else if(res.ErrorCode == SOF_CERT_REVOKED)
				alert("P1文件签名失败，证书已被吊销!");
			else if(res.ErrorCode == SOF_CERT_NOT_TRUSTED)
				alert("P1文件签名失败，证书不被信任!");
			else
				ShowError(res);
		}
    });
}

//20.P1文件验签
function Test_PKCS1_File_VerifySign()
{
    var sign_cert = testForm.sign_cert.value;  
	var sInFilePath = testForm.SignInFilePath.value;
    var sSignedValue64 = testForm.FileSignedValue.value;

	if(sign_cert.length == 0 || sign_cert == null){
		alert("签名证书为空");
		return;
	}
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_VerifySignedFile(sign_cert, sInFilePath, sSignedValue64, function(res){
		t2 = new Date().getTime();
		testForm.elapse20_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("P1文件验签成功");
		}else
			ShowError(res);
    });
}

function SetSignMessageTSPURL()
{
	var ts_url = testForm.signmsg_ts_url.value;

	if(ts_url.length == 0){
		alert('地址不能为空！');
		return;
	}

    var res = gPKISvc.SOF_Config(SOF_SET_TSP_URL, ts_url, function(res){
		if(res.ErrorCode == SOR_OK){
			alert("设置成功");
		}else
			ShowError(res);
    });
}

//带时间戳要接口版本1.1.0及以上版本
function SetSignMessageTSPURL()
{
	if(g_api_ver < '1.1.0'){
		alert('当前客户端版本不支持此功能，需要4.1.10及以上版本!');
		return;
	}
	
	var ts_url = testForm.signmsg_ts_url.value;
	if(testForm.signmsg_with_ts.checked && ts_url.length == 0){
		alert('时间戳地址不能为空！');
		return;
	}
	
	gPKISvc.SOF_Config(SOF_SET_SIGNMESSAGE_WITH_TSP, testForm.signmsg_with_ts.checked?1:0, function(res){
		if(res.ErrorCode == SOR_OK){
			if(testForm.signmsg_with_ts.checked){
				var ts_digest = testForm.signmsg_ts_digest.value;

				gPKISvc.SOF_Config(SOF_SET_TSP_DIGEST_ALG, ts_digest, function(res){
					if(res.ErrorCode == SOR_OK){
						gPKISvc.SOF_Config(SOF_SET_TSP_URL, ts_url, function(res){
							if(res.ErrorCode == SOR_OK){
								alert("设置成功");
							}
							else
								ShowError(res);
						});
					}
					else
						ShowError(res);
				});
			}else
				alert("设置成功");
		}else
			ShowError(res);
	});
		
}

//21.P7签名
function Test_SignMessage()
{
	testForm.signed_msg.value = '';
	
    if(!CheckUser())
        return;

    var plain_data = testForm.signmsg_plain_data.value;
    var sign_flag = parseInt(testForm.sign_flag.value);
	
	gPKISvc.SOF_SignMessage(sign_flag, gsSelectContainer, plain_data, function(res){
		if(res.ErrorCode == SOR_OK){
			t2 = new Date().getTime();
			testForm.elapse21_1.value = t2 - t1;
			testForm.signed_msg.value = res.Result.SignData;
			alert("P7签名成功");
		}else{
			//此处错误码判断，需要4.1.7以上版本
			if(res.ErrorCode == SOR_P7SignErr)
				alert("P7签名失败，请确认是否登录!");
			else if(res.ErrorCode == SOF_CERT_HASEXPIRED)
				alert("P7签名失败，证书已过期!");
			else if(res.ErrorCode == SOF_CERT_REVOKED)
				alert("P7签名失败，证书已被吊销!");
			else if(res.ErrorCode == SOF_CERT_NOT_TRUSTED)
				alert("P7签名失败，证书不被信任!");
			else if(res.ErrorCode == SOR_IndataErr)
				alert("P7签名失败：原文不是Base64格式!");
			else if(res.ErrorCode == SOR_TSP_DataErr)
				alert("P7签名失败：时间戳服务器数据错误!");
			else if(res.ErrorCode == SOR_TSP_Err)
				alert("P7签名失败：时间戳服务器错误!");
			else
				ShowError(res);
		}
	});

}

//21.p7验签
function Test_VerifyMessage()
{
    var signed_msg = testForm.signed_msg.value;
    var plain_data = testForm.signmsg_plain_data.value;
    var sign_flag = parseInt(testForm.sign_flag.value);
    
	if(sign_flag == SIGN_FLAG_WITH_ORI) plain_data = null;
	
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_VerifySignedMessage(signed_msg, plain_data, function(res){
		t2 = new Date().getTime();
		testForm.elapse21_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("P7验签成功");
		}else
			ShowError(res);
    });
}

//21.P7解析签名
function Test_ParseSignMessage()
{
	var signed_msg = testForm.signed_msg.value;
    var iParseType = parseInt(testForm.ParseType.value);

	testForm.SignMsgInfo.value = '';
    
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_GetInfoFromSignedMessage(signed_msg, iParseType, function(res){
		t2 = new Date().getTime();
		testForm.elapse21_3.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.SignMsgInfo.value = res.Result.Info;
		}else
			ShowError(res);
    });
}

//23.P7文件签名
function Test_Pkcs7_File_Sign()
{
	testForm.P7SignedValue.value = '';
    if(!CheckUser())
       return;

	var sInFilePath = testForm.P7_SignInFilePath.value;
	var psignfile_flag = parseInt(testForm.signfile_flag.value);

	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_Ext_PKCS7_SignFile(gsSelectContainer, sInFilePath, psignfile_flag, function(res){
		t2 = new Date().getTime();
		testForm.elapse23_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.P7SignedValue.value = res.Result.Sign;
			alert("P7文件签名成功");
		}else{
			if(res.ErrorCode == SOR_P7SignErr)
				alert("P7签名失败，请确认是否登录!");
			else if(res.ErrorCode == SOF_CERT_HASEXPIRED)
				alert("P7签名失败，证书已过期!");
			else if(res.ErrorCode == SOF_CERT_REVOKED)
				alert("P7签名失败，证书已被吊销!");
			else if(res.ErrorCode == SOF_CERT_NOT_TRUSTED)
				alert("P7签名失败，证书不被信任!");
			else
				ShowError(res);
		}
    });
}

//23.P7文件验签
function Test_Pkcs7_File_VerifySign()
{
	var signed_msg = testForm.P7SignedValue.value;
    var sInFilePath = testForm.P7_SignInFilePath.value;
    var psignfile_flag = parseInt(testForm.signfile_flag.value);
    
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_PKCS7_VerifySignedFile(signed_msg, sInFilePath, psignfile_flag, function(res){
		t2 = new Date().getTime();
		testForm.elapse23_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("P7验签成功");
		}else
			ShowError(res);
    });
}

//24.设置加密格式
function Test_SetEnvelopType()
{
	var envType = parseInt(testForm.EnvType.value);

    var res = gPKISvc.SOF_Ext_SetEnvelopType(envType, function(res){
		if(res.ErrorCode == SOR_OK){
			alert("设置成功");
		}else
			ShowError(res);
    });
}

//24.P7加密
function Test_Encrypt()
{
	testForm.EncryptedData.value = '';
	
	if(!CheckScan()) return;
	
    var sEncryptPlainData = testForm.EncryptPlainData.value;

    if(!CheckCert(CERT_TYPE_EXCHANGE))
        return;
        
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_EncryptData(testForm.enc_cert.value, sEncryptPlainData, function(res){
		t2 = new Date().getTime();
		testForm.elapse24_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.EncryptedData.value=res.Result.EncryptData;
			alert("P7加密成功");
		}else
			ShowError(res);
    });
}

//24.P7解密
function Test_Decrypt()
{
	testForm.DecryptedData.value = '';
	
	if(!CheckScan()) return;
	
    if(!CheckUser())
        return;
	
	var sEncryptedDataB64 = testForm.EncryptedData.value;
	var sEncryptPlainData = testForm.EncryptPlainData.value;
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_DecryptData(gsSelectContainer, sEncryptedDataB64, function(res){
		t2 = new Date().getTime();
		testForm.elapse24_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			if(sEncryptPlainData == res.Result.DecryptData)
				alert("P7解密成功");
			else
				alert("P7解密失败,解密出结果和原文不相等");

			testForm.DecryptedData.value = res.Result.DecryptData;
		}else{
			//此处错误码判断，需要4.1.7以上版本
			if(res.ErrorCode == SOR_P7DecErr)
				alert("P7解密失败，请确认是否登录!")
			else
				ShowError(res);
		}
    });
}

//26.P7文件加密
function Test_PKCS7_File_Encrypt()
{
	if(!CheckScan()) return;
	
	var sEnc_cert = testForm.enc_cert.value;
	var sInFilePath = testForm.EncInFilePath.value;
    var sOutFilePath = testForm.EncOutFilePath.value;

    if(!CheckCert(CERT_TYPE_EXCHANGE))
        return;
        
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_EncryptFile(sEnc_cert, sInFilePath, sOutFilePath, function(res){
		t2 = new Date().getTime();
		testForm.elapse26_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("P7文件加密成功");
		}else
			ShowError(res);
    });
}

//26.P7文件解密
function Test_PKCS7_File_Decrypt()
{
	if(!CheckScan()) return;
	
    if(!CheckUser())
        return;
	
	 var sInFilePath = testForm.DecInFilePath.value;
     var sOutFilePath = testForm.DecOutFilePath.value;
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_DecryptFile(gsSelectContainer, sInFilePath, sOutFilePath, function(res){
		t2 = new Date().getTime();
		testForm.elapse26_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("P7文件解密成功");
		}else{
			//此处错误码判断，需要4.1.7以上版本
			if(res.ErrorCode == SOR_P7DecErr)
				alert("P7文件解密失败，请确认是否登录!");
			else
				ShowError(res);
		}
    });
}

//27.随机数
function Test_GenRandom()
{
	var gen_len = parseInt(testForm.RandomLen.value);

	testForm.RandomData.value = '';
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_GenRandom(gen_len, function(res){
		t2 = new Date().getTime();
		testForm.elapse27.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.RandomData.value = res.Result.RandomData;
		}else
			ShowError(res);
    });
}

//28.读标签
function Test_Ext_ReadLabel()
{
	testForm.LabelData.value='';
	if(!CheckScan()) return;
	
	var lable_name = testForm.preset_lable_name.value;
	var lable_type = GDCA_LBL_EXDATA;

	if(lable_name == "custom"){
		lable_type = GDCA_LBL_EXDATA;
		lable_name = testForm.custom_lable_name.value;
	}else if(lable_name == LAB_USERCERT_SIG)
		lable_type = GDCA_LBL_SIGNCERT;
	else if(lable_name == LAB_USERCERT_ENC)
		lable_type = GDCA_LBL_ENCCERT;
	else if(lable_name == CA_CERT)
		lable_type = GDCA_LBL_CACERT;
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_ReadLabel(gsSelectContainer, lable_name, lable_type, function(res){
		t2 = new Date().getTime();
		testForm.elapse28.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.LabelData.value = res.Result.lableData;
			alert("读标签成功");
		}else{
			if(res.ErrorCode == SOR_CertNotFountErr)
				alert("标签不存在");
			else
				ShowError(res);
		}
    });
}

//29.写/读 多用户数据
function Test_Ext_WriteUsrDataFile()
{
	if(!CheckScan()) return;

	if(testForm.WriteData.value.length == 0){
		alert("写入数据为空！");
		return;
	}
	
	var userpin = testForm.FilePIN.value;
	var nFileType = parseInt(testForm.FileType.value, 16);
	var nFileIndex = parseInt(testForm.FileIndex.value, 10);
	var nFileOffset = parseInt(testForm.FileOffset.value, 10);
	var sWriteData = testForm.WriteData.value;

	var nLen = 0;
	var i = 0;

	for(i = 0; i < sWriteData.length; i++) 
	{ 
		if(sWriteData.charCodeAt(i) > 128)
			nLen = nLen + 3;
		else
			nLen = nLen + 1;	
	}
	
	alert("写入长度: " + nLen);

	var sWriteDataBase64 = CryptoJSUtil.base64Encode(testForm.WriteData.value); 
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_WriteUsrDataFile(gsSelectContainer, userpin, nFileType, nFileIndex, nFileOffset, sWriteDataBase64, function(res){
		t2 = new Date().getTime();
		testForm.elapse29_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("写入成功");
		}else{
			if(res.ErrorCode == SOR_IndataErr)
				alert("写多用户数据失败：写入数据不是Base64格式");
			else
				ShowError(res);
		}
    });
}

//29.读多用户数据
function Test_Ext_ReadUsrDataFile()
{
	if(!CheckScan()) return;
	
	var nFileType = parseInt(testForm.FileType.value, 16);
	var nFileIndex = parseInt(testForm.FileIndex.value, 10);
	var nFileOffset = parseInt(testForm.FileOffset.value, 10);
	var nReadLen = parseInt(testForm.ReadLen.value, 10);
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_ReadUsrDataFile(gsSelectContainer, nFileType, nFileIndex, nFileOffset, nReadLen, function(res){
		t2 = new Date().getTime();
		testForm.elapse29_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.ReadData.value = res.Result.ReadData;
			try{
				testForm.ReadDataBase64DecodeData.value = CryptoJSUtil.base64Decode(res.Result.ReadData);  
			}catch(e){
				testForm.ReadDataBase64DecodeData.value = '';
			}
		}else{
			testForm.ReadData.value = '';
			testForm.ReadDataBase64DecodeData.value = '';
			ShowError(res);
		}
    });
}

function onHashAlgSel() {
	var hash_alg = parseInt(testForm.hash_alg.value, 16);

	if(hash_alg != SGD_SM3){
		document.getElementById('hash_uid').disabled = true;
		document.getElementById('hash_pubkey').disabled = true;
	}else{
		document.getElementById('hash_uid').disabled = false;
		document.getElementById('hash_pubkey').disabled = false;
	}
}

function Test_DataHash()
{
	var hashAlg = parseInt(testForm.hash_alg.value, 16);
	var inData = testForm.hash_in_data.value;
	var pubKey = '';
	var uid = '';
	var inDataFmt = parseInt($("#hash_indata_format").val());

	if(hashAlg == SGD_SM3){
		pubKey = testForm.hash_pubkey.value;
		uid = testForm.hash_uid.value;
	}

    var t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_HashData(hashAlg, inData, inDataFmt, pubKey, uid, function(res){
		t2 = new Date().getTime();
		testForm.elapse40.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("计算哈希成功");
			testForm.hash_val.value = res.Result.HashValue;
		}else
			ShowError(res);
    });
}

function Test_FileHash()
{
	var hashAlg = parseInt(testForm.hash_alg.value, 16);
	var inData = testForm.hash_in_data.value;
	var pubKey = '';
	var uid = '';
	var filepath = $('#hash_file_path').val();
	
	if(hashAlg == SGD_SM3){
		pubKey = testForm.hash_pubkey.value;
		uid = testForm.hash_uid.value;
	}
		
    var t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_HashFile(hashAlg, filepath, pubKey, uid, function(res){
		t2 = new Date().getTime();
		testForm.elapse40.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("文件哈希成功");
			testForm.hash_val.value = res.Result.HashValue;
		}else{
			if(res.ErrorCode == SOR_FileErr)
				alert("文件打开错误，请确认输入文件是否存在!")
			else
				ShowError(res);
		}
    });
}

//31.XML签名
function Test_XMLSign()
{
	testForm.xml_signed.value = '';

    if(!CheckUser())
        return;

	var xml_sign_plain = testForm.xml_sign_plain.value;
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_SignDataXML(gsSelectContainer, xml_sign_plain, function(res){
		t2 = new Date().getTime();
		testForm.elapse31_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.xml_signed.value = res.Result.SignedData;
			alert("XML签名成功");
		}else{
			//此处错误码判断，需要4.1.7以上版本
			if(res.ErrorCode == SOR_RsaEncErr || res.ErrorCode == SOR_ECCEncErr)
				alert("XML签名失败，请确认是否登录!")
			else if(res.ErrorCode == SOF_CERT_HASEXPIRED)
				alert("XML签名失败，证书已过期!");
			else if(res.ErrorCode == SOF_CERT_REVOKED)
				alert("XML签名失败，证书已被吊销!");
			else if(res.ErrorCode == SOF_CERT_NOT_TRUSTED)
				alert("XML签名失败，证书不被信任!");
			else
				ShowError(res);
		}
    });
}

//31.XML验签
function Test_VerifyXMLSign()
{
	var xml_signed = testForm.xml_signed.value;
	
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_VerifySignedDataXML(xml_signed, function(res){
		t2 = new Date().getTime();
		testForm.elapse31_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("验签成功");
		}else{
			ShowError(res);
		}
    });
}

//31.解析XML签名数据
function Test_ParseXMLSignResult()
{
    var xml_signed = testForm.xml_signed.value;
    var xml_info_type = parseInt(testForm.xml_info_type.value);

	testForm.xml_sign_info.value = '';
    
	t1 = new Date().getTime();

    var res = gPKISvc.SOF_GetXMLSignatureInfo(xml_signed, xml_info_type, function(res){
		t2 = new Date().getTime();
		testForm.elapse31_3.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			testForm.xml_sign_info.value = res.Result.Info;
		}else
			ShowError(res);
    });
}

//32.获取时间戳
function Test_Ext_GM_TspGetTime()
{
	$('#gm_tsp_time').val('');
	
	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_Ext_TspGetTime(function(res){
		t2 = new Date().getTime();
		testForm.elapse32_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			$('#gm_tsp_time').val(res.Result.TimeStamp);
			alert("获取时间戳成功");
		}else
			ShowError(res);
    });
}

//32.加盖时间戳
function Test_Ext_GM_TspSealTimeStamp()
{
	var in_data = testForm.gm_tsp_in_data.value;
	var algType = parseInt(testForm.gm_tsp_alg_type.value, 16);
	var codeType = parseInt(testForm.gm_tsp_indata_code.value);
	
	$('#gm_tsp_timestamp').val('');

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_TspGetStamp(in_data, algType, function(res){
		t2 = new Date().getTime();
		testForm.elapse32_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			$('#gm_tsp_timestamp').val(res.Result.SealData);
			alert("加盖时间戳成功");
		}else{
			if(codeType == 2 && res.ErrorCode == SOR_IndataErr)
				alert("输入数据错误，必须是base64格式！");
			else
				ShowError(res);
		}
    });
}

//32.验证时间戳
function Test_Ext_GM_TspVerifyTimeStamp()
{
	var gm_tsp_in_data = $('#gm_tsp_in_data').val();
	var gm_tsp_timestamp = $('#gm_tsp_timestamp').val();
	var cert = '';

	$('#gm_tsp_verify_result').val('');

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_TspVerifyStamp(gm_tsp_in_data, gm_tsp_timestamp, cert, function(res){
		t2 = new Date().getTime();
		testForm.elapse32_3.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			$('#gm_tsp_verify_result').val(res.Result.TimeStamp);
			alert('验证时间戳成功');
		}else
			ShowError(res);
    });
}

//33.接口控制
function apiControl(obj, ctrl_name, ctrl_cmd)
{
    if(!CheckUser())
        return;
        
	var ctrl_cmd = get_radio_val(ctrl_cmd);

	t1 = new Date().getTime();
	
    var res = gPKISvc.SOF_Ext_Control(gsSelectContainer, ctrl_name, ctrl_cmd, function(res){
		t2 = new Date().getTime();
		testForm.elapse33.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("设置成功");
		}else
			ShowError(res);
    });
};

//34.文件对称加密
function Test_SymmEncFile()
{
	var symmAlg = parseInt(testForm.symmAlg.value, 16);
	var symmKey = testForm.symmKey.value;
	var symmIV = testForm.symmIV.value;
	var inFilePath = $('#symmFileEncInPath').val();
	var outFilePath = $('#symmFileEncOutPath').val();

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_SymmEncryptFile(symmAlg, symmKey, symmIV, inFilePath, outFilePath, function(res){
		t2 = new Date().getTime();
		testForm.elapse34_1.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("加密成功");
		}else{
			if(res.ErrorCode == SOR_IndataLenErr)
				alert("密钥或初始向量长度不正确，3DES为24，其它算法16")
			else if(res.ErrorCode == SOR_FileErr)
				alert("文件打开错误，请确认输入文件是否存在!")
			else
				ShowError(res);
		}
    });
}

//34.文件对称解密
function Test_SymmDecFile()
{
	var symmAlg = parseInt(testForm.symmAlg.value, 16);
	var symmKey = testForm.symmKey.value;
	var symmIV = testForm.symmIV.value;
	var inFilePath = $('#symmFileDecInPath').val();
	var outFilePath = $('#symmFileDecOutPath').val();

	t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_SymmDecryptFile(symmAlg, symmKey, symmIV, inFilePath, outFilePath, function(res){
		t2 = new Date().getTime();
		testForm.elapse34_2.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("解密成功");
		}else{
			if(res.ErrorCode == SOR_IndataLenErr)
				alert("密钥或初始向量长度不正确，3DES为24，其它算法16")
			else if(res.ErrorCode == SOR_FileErr)
				alert("文件打开错误，请确认输入文件是否存在!")
			else
				ShowError(res);
		}
    });
}

function GetFileReadRights()
{
	var frr_admin = document.getElementById('frr_admin');
	var frr_user = document.getElementById('frr_user');
	var frr_everyone = document.getElementById('frr_everyone');

	var rights = 0;

	if(frr_admin.checked)
		rights |= SECURE_ADM_ACCOUNT;
		
	if(frr_user.checked)
		rights |= SECURE_USER_ACCOUNT;
		
	if(frr_everyone.checked)
		rights |= SECURE_EVERYONE_ACCOUNT;

	return rights;
}

function GetFileWriteRights()
{
	var frw_admin = document.getElementById('frw_admin');
	var frw_user = document.getElementById('frw_user');
	var frw_everyone = document.getElementById('frw_everyone');

	var rights = 0;

	if(frw_admin.checked)
		rights |= SECURE_ADM_ACCOUNT;
		
	if(frw_user.checked)
		rights |= SECURE_USER_ACCOUNT;
		
	if(frw_everyone.checked)
		rights |= SECURE_EVERYONE_ACCOUNT;

	return rights;
}

function Test_CreateFile()
{
	var file_name = testForm.file_create_name.value;
	var file_len = parseInt(testForm.file_create_length.value, 10);
	var readRights = GetFileReadRights();
	var writeRights = GetFileWriteRights();
	
    var t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_CreateFile(gsSelectContainer, file_name, file_len, readRights, writeRights, function(res){
		t2 = new Date().getTime();
		testForm.elapse35.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert("创建成功");
		}else
			ShowError(res);
    });
}

function OnFileSelected()
{
    var idx = testForm.file_list.options.selectedIndex;
    
	if(idx == -1)
		return;

	g_select_file_name = g_file_list[idx];

	testForm.file_name_wr.value =g_select_file_name;
}

function Test_EnumFile()
{
	var file_list = document.getElementById('file_list');
	g_file_list = [];
	
    if(!CheckUser())
       return;
       
    //先清除原来的内容
	file_list.length=0;
	
    for (i = 0; i < testForm.file_list.options.length; i++)
        testForm.file_list.options.remove(0);

    var t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_EnumFile(gsSelectContainer, function(res){
		t2 = new Date().getTime();
		testForm.elapse36.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			var FileNames = res.Result.FileNames;
			
		    if(FileNames.length > 0)
				g_file_list = FileNames.split("&&");

			if(g_file_list.length > 0){
		    	for (i = 0; i < g_file_list.length; i++)
					file_list.options.add(new Option(g_file_list[i]), i);
					
		    	testForm.file_list.options[0].selected = true;
		    	OnFileSelected();
			}else{
		    	alert("找不到文件!");
			}
		}else
			ShowError(res);
    });
}

function Test_GetFileAttr()
{
    if(!CheckUser())
       return;
       	
    var t1 = new Date().getTime();

    testForm.elapse36.value = t2 - t1;
    
    var res = gPKISvc.SOF_Ext_GetFileAttribute(gsSelectContainer, g_select_file_name, function(res){
		t2 = new Date().getTime();
		testForm.elapse36.value = t2 - t1;
		
		var fileAttr = res.Result.FileAttr;
		
		if(res.ErrorCode == SOR_OK){
			testForm.file_length.value = fileAttr.fileSize.toString();
			testForm.file_read_rights.value = fileAttr.readRights.toString();
			testForm.file_write_rights.value = fileAttr.writeRights.toString();
		}else
			ShowError(res);
    });
}

function Test_ReadFile()
{
	var file_name = testForm.file_name_wr.value;
	var file_offset = parseInt(testForm.file_offset.value, 10);
	var file_read_len = parseInt(testForm.file_read_len.value, 10);
	
    if(!CheckUser())
       return;
       
    var t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_ReadFile(gsSelectContainer, file_name, file_offset, file_read_len, function(res){
		t2 = new Date().getTime();
		testForm.elapse37.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			var fileData = res.Result.FileData;
			
			testForm.file_read_data.value = fileData;
			//testForm.fdata_hex.value = GDCACom.SOF_Ext_Base64DecodeToHexStr(fileData, 24, true);
			testForm.fdata_base64_decode.value = gPKISvc.base64Decode(fileData);
		}else
			ShowError(res);
    });
}

function Test_WriteFile()
{
	var file_name = testForm.file_name_wr.value;
	var write_data = testForm.file_write_data.value;
	var file_offset = parseInt(testForm.file_offset.value, 10);
	var fw_indata_fmt = parseInt(get_radio_val('fw_indata_fmt'));
	
    if(!CheckUser())
       return;
       
	if(write_data.length == 0){
		alert('写入数据不能为空!');
		return;
	}

	var nLen = 0;
	var i = 0;
		
	for(i = 0; i < write_data.length; i++) 
	{ 
		if(write_data.charCodeAt(i) > 128)
			nLen = nLen + 3;
		else
			nLen = nLen + 1;	
	}
	
	alert("写入长度: " + nLen);
	
    var t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_WriteFile(gsSelectContainer, file_name, file_offset, fw_indata_fmt, write_data, function(res){
		t2 = new Date().getTime();
		testForm.elapse37.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert('写入成功');
		}else
			ShowError(res);
    });
}

function Test_DeleteFile()
{
	var file_name = testForm.file_name_wr.value;
	
    if(!CheckUser())
       return;
       
    var t1 = new Date().getTime();

    var res = gPKISvc.SOF_Ext_DeleteFile(gsSelectContainer, file_name, function(res){
		t2 = new Date().getTime();
		testForm.elapse37.value = t2 - t1;
		
		if(res.ErrorCode == SOR_OK){
			alert('删除成功');
		}else
			ShowError(res);
    });
}

//35.清理
function Test_Finalize()
{
    var res = gPKISvc.SOF_Finalize(function(res){
		if(res.ErrorCode == SOR_OK){
			alert("清理成功");
		}else
			ShowError(res);
    });
}



