var os_type_t = 
{
    unknow:0,
    windows:1,
    linux:2,
    mac:3,
    unix:4
}

//从右往左去空格
function rtrim(stringObj) {
    while (stringObj.charCodeAt(stringObj.length - 1) == 32) {
        stringObj = stringObj.substring(0, stringObj.length - 1);
    }
    return stringObj;
}

//从左往右去空格
function ltrim(stringObj) {
    while (stringObj.charCodeAt(0) == 32) {
        stringObj = stringObj.substring(1, stringObj.length);
    }
    return stringObj;
}

//去掉字符串左右两边的空格
function trim(stringObj) {
    return(ltrim(rtrim(stringObj)));
}

/*****************************************************
 *  函数名称：replaceChars;
 *  函数功能：替换字符串中的相应字符串;
 *******************************************************/
function replaceChars(entry, orgStr, replaceStr) {
    temp = "" + entry;
    while (temp.indexOf(orgStr) > -1) {
        pos = temp.indexOf(orgStr);
        temp = "" + (temp.substring(0, pos) + replaceStr + temp.substring((pos + orgStr.length), temp.length));
    }

    return temp;
}

function FilePathAddSufix(path, sufix) {

    var idx = path.lastIndexOf(".");
    if(idx != -1)
    {
        return path.substr(0, idx) + sufix + path.substr(idx);
    }
    else
    {
        return path + sufix;
    }
}

function InsertObjectNode(webCore, sObjName, sClassid) {
    if(webCore == 1)
    {
        document.writeln("<OBJECT id=\"" + sObjName + "\" classid=\"CLSID:" + sClassid + "\" style=\"display:none\"></OBJECT>");
    }else{
        document.writeln("<OBJECT id=\"" + sObjName + "\" TYPE=\"application/gdca-activex\" clsid=\"{" + sClassid + "}\" WIDTH=\"0\" HEIGHT=\"0\"></OBJECT>");
    }
}

function LoadComObj(sObjName, sClassid) {
    var browser = navigator.appName;

    //判断浏览器类型选择合适的ActiveX控件调用方式
    if (browser == "Microsoft Internet Explorer")  //IE浏览器
    {
        InsertObjectNode(1, sObjName, sClassid);
    }
    else if (browser == "Netscape")  //IE11, Chrome,Firefox浏览器
    {
        if (navigator.userAgent.search("Trident") != -1) //IE11
            InsertObjectNode(1, sObjName, sClassid);
        else
            InsertObjectNode(2, sObjName, sClassid);
    }
}

/**
 * Created with JetBrains WebStorm.
 * User: Saturn
 * Date: 12-7-3
 * Time: 下午3:57
 * To change this template use File | Settings | File Templates.
 */
/*
 * MAP对象，实现MAP功能
 *
 * 接口：
 * size()     获取MAP元素个数
 * isEmpty()    判断MAP是否为空
 * clear()     删除MAP所有元素
 * put(key, value)   向MAP中增加元素（key, value)
 * remove(key)    删除指定KEY的元素，成功返回True，失败返回False
 * get(key)    获取指定KEY的元素值VALUE，失败返回NULL
 * element(index)   获取指定索引的元素（使用element.key，element.value获取KEY和VALUE），失败返回NULL
 * containsKey(key)  判断MAP中是否含有指定KEY的元素
 * containsValue(value) 判断MAP中是否含有指定VALUE的元素
 * values()    获取MAP中所有VALUE的数组（ARRAY）
 * keys()     获取MAP中所有KEY的数组（ARRAY）
 *
 * 例子：
 * var map = new Map();
 *
 * map.put("key", "value");
 * var val = map.get("key")
 * ……
 *
 */
function Map() {
    this.elements = new Array();

    //获取MAP元素个数
    this.size = function () {
        return this.elements.length;
    }

    //判断MAP是否为空
    this.isEmpty = function () {
        return (this.elements.length < 1);
    }

    //删除MAP所有元素
    this.clear = function () {
        this.elements = new Array();
    }

    //向MAP中增加元素（key, value)
    this.put = function (_key, _value) {
        this.elements.push({
            key:_key,
            value:_value
        });
    }

    //删除指定KEY的元素，成功返回True，失败返回False
    this.remove = function (_key) {
        var bln = false;
        try {
            for (i = 0; i < this.elements.length; i++) {
                if (this.elements[i].key == _key) {
                    this.elements.splice(i, 1);
                    return true;
                }
            }
        } catch (e) {
            bln = false;
        }
        return bln;
    }

    //获取指定KEY的元素值VALUE，失败返回NULL
    this.get = function (_key) {
        try {
            for (i = 0; i < this.elements.length; i++) {
                if (this.elements[i].key == _key) {
                    return this.elements[i].value;
                }
            }
        } catch (e) {
            return null;
        }
    }

    //获取指定索引的元素（使用element.key，element.value获取KEY和VALUE），失败返回NULL
    this.element = function (_index) {
        if (_index < 0 || _index >= this.elements.length) {
            return null;
        }
        return this.elements[_index];
    }

    //判断MAP中是否含有指定KEY的元素
    this.containsKey = function (_key) {
        var bln = false;
        try {
            for (i = 0; i < this.elements.length; i++) {
                if (this.elements[i].key == _key) {
                    bln = true;
                }
            }
        } catch (e) {
            bln = false;
        }
        return bln;
    }

    //判断MAP中是否含有指定VALUE的元素
    this.containsValue = function (_value) {
        var bln = false;
        try {
            for (i = 0; i < this.elements.length; i++) {
                if (this.elements[i].value == _value) {
                    bln = true;
                }
            }
        } catch (e) {
            bln = false;
        }
        return bln;
    }

    //获取MAP中所有VALUE的数组（ARRAY）
    this.values = function () {
        var arr = new Array();
        for (i = 0; i < this.elements.length; i++) {
            arr.push(this.elements[i].value);
        }
        return arr;
    }

    //获取MAP中所有KEY的数组（ARRAY）
    this.keys = function () {
        var arr = new Array();
        for (i = 0; i < this.elements.length; i++) {
            arr.push(this.elements[i].key);
        }
        return arr;
    }
}

function setOpacity(obj, opacity) { 
	if (obj.style.opacity != undefined) { 
		obj.style.opacity = opacity;  ///兼容FF和GG和新版本IE 
	} else { 
		obj.style.filter = "alpha(opacity=" + opacity * 100 + ")";  ///兼容老版本ie 
	} 
}

var is_fading = false;

//淡入
function fadein(obj, interval, precision) {
	var num = 0;
    if (!is_fading) {
        var st = setInterval(function(){
            num++;
            is_fading = true;
            setOpacity(obj, num / precision);
            if (num >= precision) {
                clearInterval(st);
                is_fading = false;
            }
        }, interval);
    }
}

 //淡出
function fadeout(obj, interval, precision, cb_end) {
	var num = precision;
    if (!is_fading) {
        var st = setInterval(function(){
            num--;
            is_fading = true;
            setOpacity(obj, num / precision);
            if (num <= 0) {
                clearInterval(st);
                is_fading = false;
                cb_end();
            }
        }, interval);
    }
}

function OnFadoutEnd() {
	var msg_wrap=document.getElementById('msg_wrap');
	msg_wrap.style.display="none";
}

//弹出一个淡入淡出的提示框, stay为停留时间
function show_msg(text, stay) {
	var msg_wrap=document.getElementById('msg_wrap');
	var msg=document.getElementById('msg');
	var old_ie = false;

	if (navigator.appName == "Microsoft Internet Explorer")  //IE浏览器
	{
		old_ie = true;
	}

	msg_wrap.style.display="inline-block";
	msg.innerHTML=text;

	old_ie?fadein(msg, 30, 20):fadein(msg_wrap, 30, 20)
		
	setTimeout(function(){
		old_ie?fadeout(msg, 30, 20, OnFadoutEnd):fadeout(msg_wrap, 30, 20, OnFadoutEnd)
	}, stay);
}

function get_radio_val(radio_name) {
	var vals = document.getElementsByName(radio_name);  
    for(var i = 0;i < vals.length;i++)  {
        if(vals[i].checked==true) {
            return vals[i].value;  
        }  
    }
    return null;
}

function genRandString(len) {
	len = len || 32;
	var $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';
	var maxPos = $chars.length;
	var s = '';
	
	for (i = 0; i < len; i++) {
		s += $chars.charAt(Math.floor(Math.random() * maxPos));
	}
	
	return s;
}

var split;


// Avoid running twice; that would break the `nativeSplit` reference

split = split || function (undef) {

    var nativeSplit = String.prototype.split,
        compliantExecNpcg = /()??/.exec("")[1] === undef, // NPCG: nonparticipating capturing group
        self;

    self = function (str, separator, limit) {
        // If `separator` is not a regex, use `nativeSplit`
        if (Object.prototype.toString.call(separator) !== "[object RegExp]") {
            return nativeSplit.call(str, separator, limit);
        }
        var output = [],
            flags = (separator.ignoreCase ? "i" : "") +
                    (separator.multiline ? "m" : "") +
                    (separator.extended ? "x" : "") + // Proposed for ES6
                    (separator.sticky ? "y" : ""), // Firefox 3+
            lastLastIndex = 0,
            // Make `global` and avoid `lastIndex` issues by working with a copy
            separator = new RegExp(separator.source, flags + "g"),
            separator2, match, lastIndex, lastLength;
        str += ""; // Type-convert
        if (!compliantExecNpcg) {
            // Doesn't need flags gy, but they don't hurt
            separator2 = new RegExp("^" + separator.source + "$(?!\\s)", flags);
        }
        /* Values for `limit`, per the spec:
         * If undefined: 4294967295 // Math.pow(2, 32) - 1
         * If 0, Infinity, or NaN: 0
         * If positive number: limit = Math.floor(limit); if (limit > 4294967295) limit -= 4294967296;
         * If negative number: 4294967296 - Math.floor(Math.abs(limit))
         * If other: Type-convert, then use the above rules
         */
        limit = limit === undef ?
            -1 >>> 0 : // Math.pow(2, 32) - 1
            limit >>> 0; // ToUint32(limit)
        while (match = separator.exec(str)) {
            // `separator.lastIndex` is not reliable cross-browser
            lastIndex = match.index + match[0].length;
            if (lastIndex > lastLastIndex) {
                output.push(str.slice(lastLastIndex, match.index));
                // Fix browsers whose `exec` methods don't consistently return `undefined` for
                // nonparticipating capturing groups
                if (!compliantExecNpcg && match.length > 1) {
                    match[0].replace(separator2, function () {
                        for (var i = 1; i < arguments.length - 2; i++) {
                            if (arguments[i] === undef) {
                                match[i] = undef;
                            }
                        }
                    });
                }
                if (match.length > 1 && match.index < str.length) {
                    Array.prototype.push.apply(output, match.slice(1));
                }
                lastLength = match[0].length;
                lastLastIndex = lastIndex;
                if (output.length >= limit) {
                    break;
                }
            }
            if (separator.lastIndex === match.index) {
                separator.lastIndex++; // Avoid an infinite loop
            }
        }
        if (lastLastIndex === str.length) {
            if (lastLength || !separator.test("")) {
                output.push("");
            }
        } else {
            output.push(str.slice(lastLastIndex));
        }
        return output.length > limit ? output.slice(0, limit) : output;
    };

    // For convenience
    String.prototype.split = function (separator, limit) {
        return self(this, separator, limit);
    };

    return self;
}();

var CryptoJSUtil = 
{
	base64Encode: function(val){
	    var src = CryptoJS.enc.Utf8.parse(val);
		return CryptoJS.enc.Base64.stringify(src).toString();
	},
	base64Decode: function(val){
	    var wa = CryptoJS.enc.Base64.parse(val);
		return CryptoJS.enc.Utf8.stringify(wa);;
	}
}

//判断插件名称是否存在
function hasPlugin(name) {
    name = name.toLowerCase();
    for (var i = 0; i < navigator.plugins.length; i++) {
        if (navigator.plugins[i].name.toLowerCase().indexOf(name) > -1) {
            return true;
        }
    }
    return false;
}

//判断操作系统
function check_os() {
    if (navigator.userAgent.indexOf("Windows", 0) != -1)
    	return os_type_t.windows;
    else if (navigator.userAgent.indexOf("Linux", 0) != -1)
    	return os_type_t.linux;
    else if (navigator.userAgent.indexOf("mac", 0) != -1)
    	return os_type_t.mac;
    else if (navigator.userAgent.indexOf("X11", 0) != -1)
    	return os_type_t.unix;
	else
		return os_type_t.unknow;
}

/****************************************************************************************
* 函数名称：getCookie
* 函数功能：客户端从cookie中得到服务方的信息
* 输入参数：name    cookie中标识名
* 输出参数：rvalue  得到标识名对应的值
*****************************************************************************************/
function getCookie(name)
{
	var cookies = document.cookie;
	var start = -1;
	var end = -1;
	var rvalue = null;

	if(cookies.length>0)
	{
	     start = cookies.indexOf(name);
	     if(start!=-1)
	     {
	          start += name.length+1;
	          end = cookies.indexOf(";",start);
	          if(end ==-1)
	          {
	              end = cookies.length;
	          }
	          rvalue = cookies.substring(start,end);
	     }
	}

	rvalue=replaceChars(rvalue,"%0D","\r");
	rvalue=replaceChars(rvalue,"%0A","\n");
	rvalue=replaceChars(rvalue,"%2F","/");
	rvalue=replaceChars(rvalue,"%2B","+");
	rvalue=replaceChars(rvalue,"%3D","=");
	return rvalue;
 }

function isIE() {
    return ("ActiveXObject" in window);
}

function IEVersion() 
{
        var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串  
        var isIE = userAgent.indexOf("compatible") > -1 && userAgent.indexOf("MSIE") > -1; //判断是否IE<11浏览器  
        var isEdge = userAgent.indexOf("Edge") > -1 && !isIE; //判断是否IE的Edge浏览器  
        var isIE11 = userAgent.indexOf('Trident') > -1 && userAgent.indexOf("rv:11.0") > -1;
        if(isIE) {
            var reIE = new RegExp("MSIE (\\d+\\.\\d+);");
            reIE.test(userAgent);
            var fIEVersion = parseFloat(RegExp["$1"]);
            if(fIEVersion == 7) {
                return 7;
            } else if(fIEVersion == 8) {
                return 8;
            } else if(fIEVersion == 9) {
                return 9;
            } else if(fIEVersion == 10) {
                return 10;
            } else {
                return 6;//IE版本<=7
            }   
        } else if(isEdge) {
            return 'edge';//edge
        } else if(isIE11) {
            return 11; //IE11  
        }else{
            return -1;//不是ie浏览器
        }
}

/*
 * 版本号比较方法
 * 传入两个字符串，当前版本号：curV；比较版本号：reqV
 * 调用方法举例：compare("1.1","1.2")，将返回false
 */
function xs_compare_ver(curV, reqV){
   if(curV && reqV){
      //将两个版本号拆成数字
      var arr1 = curV.split('.'),
          arr2 = reqV.split('.');
      var minLength=Math.min(arr1.length,arr2.length),
          position=0,
          diff=0;
      //依次比较版本号每一位大小，当对比得出结果后跳出循环（后文有简单介绍）
      while(position<minLength && ((diff=parseInt(arr1[position])-parseInt(arr2[position]))==0)){
          position++;
      }
      diff=(diff!=0)?diff:(arr1.length-arr2.length);
      //若curV大于reqV，则返回true
      return diff>0;
   }else{
      //输入为空
      console.log("版本号不能为空");
      return false;
   }
}
